﻿using System;
using System.Reflection;

namespace DynamicallyInvokingAMethod
{
    public class Tester
    {
        public static void Main()
        {
            Type theMathType = Type.GetType("System.Math");
            // Z uwagi na to, że klasa System.Math nie ma publicznego konstruktora,
            // poniższa instrukcja spowodowałaby zgłoszenie wyjątku.
            // Object theObj =
            //     Activator.CreateInstance(theMathType);

            // Tablica zawierająca jeden element
            Type[] paramTypes = new Type[1];
            paramTypes[0] = Type.GetType("System.Double");

            // Pobranie informacji na temat metody Cos
            MethodInfo CosineInfo =
            theMathType.GetMethod("Cos", paramTypes);

            // Wypełnienie tablicy odpowiednimi wartościami argumentów
            Object[] parameters = new Object[1];
            parameters[0] = 45 * (Math.PI / 180); // 45 stopni w radianach
            Object returnVal =
                CosineInfo.Invoke(theMathType, parameters);
            Console.WriteLine(
                "Cosinus kąta 45 stopni wynosi {0}",
                returnVal);
        }
    }
}